;----------------------------------------------------------------------------

;Title	: DDS-based strobo
;Version: 1.00
;Target	: ATtiny12
;Author	: wubblick@yahoo.com

;AVR Assembler 2.0

;Fuse bits: 0x1A

;----------------------------------------------------------------------------

.include "tn12def.inc"

;----------------------------------------------------------------------------

;Constants:

.equ	RPM33	= 33333		;33 1/3 rpm (x1000)
.equ	RPM45	= 45000		;45 rpm     (x1000)
.equ	N33_50	= 180		;stripes number 33 1/3 rpm @ 50 Hz
.equ	N45_50	= 133		;stripes number 45 rpm     @ 50 Hz
.equ	N45A_50	= 180		;stripes number 45 rpm     @ 50 Hz
.equ	N33_60	= 216		;stripes number 33 1/3 rpm @ 60 Hz

.equ	F_CLK	= 4000000	;Fclk, Hz

.equ	DIV_N	= 256		;clk to overflow Timer0

.equ	FREQ33_50  = DIV_N * 0xFFFFFF * RPM33 * N33_50 / (60000 * F_CLK)
.equ	FREQ45_50  = DIV_N * 0xFFFFFF * RPM45 * N45_50 / (60000 * F_CLK)
.equ	FREQ45A_50 = DIV_N * 0xFFFFFF * RPM45 * N45A_50 / (60000 * F_CLK)
.equ	FREQ33_60  = DIV_N * 0xFFFFFF * RPM33 * N33_60 / (60000 * F_CLK)

;----------------------------------------------------------------------------

;Ports definition:

.equ LED    = PB0 ;LED output, active high
.equ SEL0   = PB1 ;frequency select 0
.equ SEL1   = PB2 ;frequency select 1

;Port B direction:
.equ DIRB   = (1 << LED)
;Port B init/pullups:
.equ PUPB   = ~(1 << LED)

;----------------------------------------------------------------------------

;Global register variables:

.def	tsreg	= r2		;SREG store

.def	Phase1	= r3		;phase code
.def	Phase2	= r4
.def	Phase3	= r5

.def	Freq1	= r16		;frequency code (delta phase)
.def	Freq2	= r17
.def	Freq3	= r18

.def	Tempi	= r19

.def	Temp	= r20
.def	Select	= r21		;frequency set

;----------------------------------------------------------------------------

.CSEG
.org 0

	rjmp	Init		;reset vector

;----------------------------------------------------------------------------

.org OVF0addr

;Timer0 overflow interrupt vector (DDS implementation)
;To minimize execution time handle is located
;at vector address. It eliminates RJMP command.

                                ;4      address store
	in	tsreg,SREG	;1	save status register

	add	Phase1,Freq1	;1      Phase = Phase + Freq
	adc	Phase2,Freq2	;1
	adc	Phase3,Freq3    ;1

	mov	Tempi,Phase3	;1
	andi	Tempi,0xF0	;1
	brne	Off		;1/2
On:	sbi	PORTB,LED	;2	LED on
	rjmp	OnOff		;2
Off:	cbi	PORTB,LED	;2	LED off
	nop			;1

OnOff:	out	SREG,tsreg	;1      restore status register
	reti                    ;4 (20 total)

;----------------------------------------------------------------------------

;Timer0 init:

Init:	ldi	Temp,(1<<CS00)	
	out	TCCR0,Temp	;CK/1
	ldi	Temp,(1<<TOIE0)	
	out	TIMSK,Temp	;timer OVF interrupt enable

;Port init:

	ldi	Temp,PUPB
	out	PORTB,Temp
	ldi	Temp,DIRB	
	out	DDRB,Temp

;Clear frequency set:

	ldi Select,0xFF

;Interrupts enable:

	sei

;Main program:

Main:	clr	Temp
	sbis	PINB,SEL0
	ori	Temp,0x01
	sbis	PINB,SEL1
	ori	Temp,0x02
	cp	Temp,Select
	breq	Main

	mov	Select,Temp

	cpi	Select,0
	brne	Sel_1
	ldi Freq1,byte1(FREQ33_50)
	ldi Freq2,byte2(FREQ33_50)
	ldi Freq3,byte3(FREQ33_50)
	rjmp Sel_4

Sel_1:	cpi	Select,1
	brne	Sel_2
	ldi Freq1,byte1(FREQ45_50)
	ldi Freq2,byte2(FREQ45_50)
	ldi Freq3,byte3(FREQ45_50)
	rjmp Sel_4

Sel_2:	cpi	Select,2
	brne	Sel_3
	ldi Freq1,byte1(FREQ45A_50)
	ldi Freq2,byte2(FREQ45A_50)
	ldi Freq3,byte3(FREQ45A_50)
	rjmp Sel_4

Sel_3:	cpi	Select,3
	brne	Sel_4
	ldi Freq1,byte1(FREQ33_60)
	ldi Freq2,byte2(FREQ33_60)
	ldi Freq3,byte3(FREQ33_60)

Sel_4:	rjmp Main

;----------------------------------------------------------------------------
